/*
As well as a powerful Component architecture, BajaScript also has a rich Object architecture...

- The core JavaScript types have been augmented into BajaScript Types.
- There are LOTS of different objects in BajaScript that match Niagara Types. Please see the JsDocs for more information!
*/

// How about a String!
baja.outln("So what's the Type for a String?".getType());

// How about a number?
baja.outln(12.2.getType());
baja.outln(baja.Double.make(12.3).getType());
baja.outln(baja.Integer.make(12).getType());
baja.outln(baja.Long.make(14).getType());
baja.outln(baja.Float.make(12.4).getType());

// How about a boolean?
baja.outln(true.getType());

// Simples that don't exist
baja.outln("What about unsupported Simples?");
baja.outln("BajaScript hasn't got an implementation for all Simples.");
baja.outln("For now, any unknown Simple falls back to a baja.DefaultSimple");
baja.outln("For example, here's a BOrdList: " + baja.$("baja:OrdList").make("slot:/"));

// How about Facets?
var facets = baja.Facets.make(["trueText", "falseText"], ["some true text", "some false text"]);

// Encode to String and print out
var encodedFacetsStr = facets.encodeToString();
baja.outln("Some encoded Facets: " + encodedFacetsStr);

// Decode from String and print out
facets = baja.Facets.DEFAULT.decodeFromString(encodedFacetsStr);

baja.outln("Let's print out the Facets...");
var keys = facets.getKeys();
for (var i = 0; i < keys.length; ++i) {
  baja.outln(" key: " + keys[i]);
  baja.outln(", value: " + facets.get(keys[i]));
}

// Relative Time
baja.outln("Milliseconds: " + baja.RelTime.make({
  hours: 1,
  minutes: 2,
  seconds: 20
}));

// Absolute time
baja.outln("Time now: " + baja.AbsTime.now());

// Enums
baja.outln(baja.$("baja:Weekday").get("monday"));

// Status
var status = baja.Status.make(baja.Status.DOWN | baja.Status.FAULT);
baja.outln("Status down: " + status.isDown());
baja.outln("Status fault: " + status.isFault());
